
#include <p18f27j53.h>
#include <stdio.h>
#include "inttypes.h"

extern uint8_t show_samples;


void EraseFlashPage(uint8_t rom far *page)
{
	if(show_samples) printf((const rom char far *)"Erase flash at %06lX\r\n", (long)page);

	TBLPTRU = ((short long)page >> 16) & 0xFF;
	TBLPTRH = ((short long)page >> 8) & 0xFC;
	TBLPTRL = 0;
	EECON1bits.WREN = 1;
	EECON1bits.FREE = 1;
	INTCONbits.GIE = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	//INTCONbits.GIE = 1;
	//EECON1bits.WREN = 0;	// Not needed???
}

void WriteFlashPage(uint8_t rom far *page, uint8_t *data)
{
	uint8_t i,j;

	if(show_samples) printf((const rom char far *)"Write flash at %06lX\r\n", (long)page);

	i = 16;
	do {
		j = 64;
		do {
			*page++ = *data++;
		} while(--j);
		EECON1bits.WREN = 1;
		INTCONbits.GIE = 0;
		EECON2 = 0x55;
		EECON2 = 0xAA;
		EECON1bits.WR = 1;
		//INTCONbits.GIE = 1;
		EECON1bits.WREN = 0;
	} while(--i);
}

#if 0
void ShowFlash(void)
{
	uint16_t a;
	uint8_t b;
	uint8_t rom far * p;

	p = (uint8_t rom far *)0x4000;
	//TBLPTRU = p >> 16;
	//TBLPTRH = (p >> 8) & 0xFF;
	//TBLPTRL = p & 0xFF;
	for(a = 0; a < 0x0400; ++a) {
		//_asm tblrdpostinc _endasm
		//b = TABLAT;
		b = *p++;
		printf((const rom char far *)"%02X ", b);
	}
}
#endif
