
//   Watchdog Timer:
//     WDTEN = OFF          Disabled - Controlled by SWDTEN bit
//     WDTEN = ON           Enabled
#pragma config WDTEN = OFF

//
//   PLL Prescaler Selection:
//     PLLDIV = 12          Divide by 12 (48 MHz oscillator input)
//     PLLDIV = 10          Divide by 10 (40 MHz oscillator input)
//     PLLDIV = 6           Divide by 6 (24 MHz oscillator input)
//     PLLDIV = 5           Divide by 5 (20 MHz oscillator input)
//     PLLDIV = 4           Divide by 4 (16 MHz oscillator input)
//     PLLDIV = 3           Divide by 3 (12 MHz oscillator input)
//     PLLDIV = 2           Divide by 2 (8 MHz oscillator input)
//     PLLDIV = 1           No prescale (4 MHz oscillator input drives PLL directly)
#pragma config PLLDIV = 1

//
//   PLL Enable Configuration Bit:
//     CFGPLLEN = ON        PLL Enabled
//     CFGPLLEN = OFF       PLL Disabled
#pragma config CFGPLLEN = OFF

//
//   Stack Overflow/Underflow Reset:
//     STVREN = OFF         Disabled
//     STVREN = ON          Enabled
#pragma config STVREN = OFF

//
//   Extended Instruction Set:
//     XINST = OFF          Disabled
//     XINST = ON           Enabled
#pragma config XINST = OFF

//
//   CPU System Clock Postscaler:
//     CPUDIV = OSC4_PLL6   CPU system clock divide by 6
//     CPUDIV = OSC3_PLL3   CPU system clock divide by 3
//     CPUDIV = OSC2_PLL2   CPU system clock divide by 2
//     CPUDIV = OSC1        No CPU system clock divide
#pragma config CPUDIV = OSC1

//
//   Code Protect:
//     CP0 = ON             Program memory is code-protected
//     CP0 = OFF            Program memory is not code-protected
#pragma config CP0 = OFF

//
//   Oscillator:
//     OSC = INTOSC         INTOSC
//     OSC = INTOSCO        INTOSCO (CLKO-RA6)
//     OSC = INTOSCPLL      INTOSCPLL
//     OSC = INTOSCPLLO     INTOSCPLLO (CLKO-RA6)
//     OSC = HS             HS, USB-HS
//     OSC = HSPLL          HS+PLL, USB-HS+PLL
//     OSC = EC             EC (CLKO-RA6), USB-EC
//     OSC = ECPLL          EC+PLL (CLKO-RA6), USB-EC+PLL
#pragma config OSC = INTOSC

//
//   T1OSC/SOSC Power Selection Bits:
//     SOSCSEL = RESERVED   Reserved
//     SOSCSEL = LOW        Low Power T1OSC/SOSC circuit selected
//     SOSCSEL = DIG        Digital (SCLKI) mode selected
//     SOSCSEL = HIGH       High Power T1OSC/SOSC circuit selected
#pragma config SOSCSEL = HIGH

//
//   EC Clock Out Enable Bit :
//     CLKOEC = OFF         CLKO output disabled on the RA6 pin
//     CLKOEC = ON          CLKO output enabled on the RA6 pin
#pragma config CLKOEC = OFF

//
//   Fail-Safe Clock Monitor:
//     FCMEN = OFF          Disabled
//     FCMEN = ON           Enabled
#pragma config FCMEN = OFF

//
//   Internal External Oscillator Switch Over Mode:
//     IESO = OFF           Disabled
//     IESO = ON            Enabled
#pragma config IESO = OFF

//
//   Watchdog Postscaler:
//     WDTPS = 1            1:1
//     WDTPS = 2            1:2
//     WDTPS = 4            1:4
//     WDTPS = 8            1:8
//     WDTPS = 16           1:16
//     WDTPS = 32           1:32
//     WDTPS = 64           1:64
//     WDTPS = 128          1:128
//     WDTPS = 256          1:256
//     WDTPS = 512          1:512
//     WDTPS = 1024         1:1024
//     WDTPS = 2048         1:2048
//     WDTPS = 4096         1:4096
//     WDTPS = 8192         1:8192
//     WDTPS = 16384        1:16384
//     WDTPS = 32768        1:32768
#pragma config WDTPS = 1

//
//   DSWDT Clock Select:
//     DSWDTOSC = T1OSCREF  DSWDT uses T1OSC/T1CKI
//     DSWDTOSC = INTOSCREF DSWDT uses INTRC
#pragma config DSWDTOSC = INTOSCREF

//
//   RTCC Clock Select:
//     RTCOSC = INTOSCREF   RTCC uses INTRC
//     RTCOSC = T1OSCREF    RTCC uses T1OSC/T1CKI
#pragma config RTCOSC = T1OSCREF

//
//   Deep Sleep BOR:
//     DSBOREN = OFF        Disabled
//     DSBOREN = ON         Enabled
#pragma config DSBOREN = OFF

//
//   Deep Sleep Watchdog Timer:
//     DSWDTEN = OFF        Disabled
//     DSWDTEN = ON         Enabled
#pragma config DSWDTEN = OFF

//
//   Deep Sleep Watchdog Postscaler:
//     DSWDTPS = 2          1:2 (2.1 ms)
//     DSWDTPS = 8          1:8 (8.3 ms)
//     DSWDTPS = 32         1:32 (33 ms)
//     DSWDTPS = 128        1:128 (132 ms)
//     DSWDTPS = 512        1:512 (528 ms)
//     DSWDTPS = 2048       1:2,048 (2.1 seconds)
//     DSWDTPS = 8192       1:8,192 (8.5 seconds)
//     DSWDTPS = K32        1:32,768 (34 seconds)
//     DSWDTPS = K131       1:131,072 (135 seconds)
//     DSWDTPS = K524       1:524,288 (9 minutes)
//     DSWDTPS = M2         1:2,097,152 (36 minutes)
//     DSWDTPS = M8         1:8,388,608 (2.4 hours)
//     DSWDTPS = M33        1:33,554,432 (9.6 hours)
//     DSWDTPS = M134       1:134,217,728 (38.5 hours)
//     DSWDTPS = M536       1:536,870,912 (6.4 days)
//     DSWDTPS = G2         1:2,147,483,648 (25.7 days)
#pragma config DSWDTPS = 2

//
//   IOLOCK One-Way Set Enable bit:
//     IOL1WAY = OFF        The IOLOCK bit (PPSCON<0>) can be set and cleared as needed
//     IOL1WAY = ON         The IOLOCK bit (PPSCON<0>) can be set once
#pragma config IOL1WAY = OFF

//
//   ADC 10 or 12 Bit Select:
//     ADCSEL = BIT12       12 - Bit ADC Enabled
//     ADCSEL = BIT10       10 - Bit ADC Enabled
#pragma config ADCSEL = BIT12

//
//   MSSP address masking:
//     MSSP7B_EN = MSK5     5 Bit address masking mode
//     MSSP7B_EN = MSK7     7 Bit address masking mode
#pragma config MSSP7B_EN = MSK7

//
//   Write/Erase Protect Page Start/End Location:
//     WPFP = PAGE_0        Write Protect Program Flash Page 0
//     WPFP = PAGE_1        Write Protect Program Flash Page 1
//     WPFP = PAGE_2        Write Protect Program Flash Page 2
//     WPFP = PAGE_3        Write Protect Program Flash Page 3
//     WPFP = PAGE_4        Write Protect Program Flash Page 4
//     WPFP = PAGE_5        Write Protect Program Flash Page 5
//     WPFP = PAGE_6        Write Protect Program Flash Page 6
//     WPFP = PAGE_7        Write Protect Program Flash Page 7
//     WPFP = PAGE_8        Write Protect Program Flash Page 8
//     WPFP = PAGE_9        Write Protect Program Flash Page 9
//     WPFP = PAGE_10       Write Protect Program Flash Page 10
//     WPFP = PAGE_11       Write Protect Program Flash Page 11
//     WPFP = PAGE_12       Write Protect Program Flash Page 12
//     WPFP = PAGE_13       Write Protect Program Flash Page 13
//     WPFP = PAGE_14       Write Protect Program Flash Page 14
//     WPFP = PAGE_15       Write Protect Program Flash Page 15
//     WPFP = PAGE_16       Write Protect Program Flash Page 16
//     WPFP = PAGE_17       Write Protect Program Flash Page 17
//     WPFP = PAGE_18       Write Protect Program Flash Page 18
//     WPFP = PAGE_19       Write Protect Program Flash Page 19
//     WPFP = PAGE_20       Write Protect Program Flash Page 20
//     WPFP = PAGE_21       Write Protect Program Flash Page 21
//     WPFP = PAGE_22       Write Protect Program Flash Page 22
//     WPFP = PAGE_23       Write Protect Program Flash Page 23
//     WPFP = PAGE_24       Write Protect Program Flash Page 24
//     WPFP = PAGE_25       Write Protect Program Flash Page 25
//     WPFP = PAGE_26       Write Protect Program Flash Page 26
//     WPFP = PAGE_27       Write Protect Program Flash Page 27
//     WPFP = PAGE_28       Write Protect Program Flash Page 28
//     WPFP = PAGE_29       Write Protect Program Flash Page 29
//     WPFP = PAGE_30       Write Protect Program Flash Page 30
//     WPFP = PAGE_31       Write Protect Program Flash Page 31
//     WPFP = PAGE_32       Write Protect Program Flash Page 32
//     WPFP = PAGE_33       Write Protect Program Flash Page 33
//     WPFP = PAGE_34       Write Protect Program Flash Page 34
//     WPFP = PAGE_35       Write Protect Program Flash Page 35
//     WPFP = PAGE_36       Write Protect Program Flash Page 36
//     WPFP = PAGE_37       Write Protect Program Flash Page 37
//     WPFP = PAGE_38       Write Protect Program Flash Page 38
//     WPFP = PAGE_39       Write Protect Program Flash Page 39
//     WPFP = PAGE_40       Write Protect Program Flash Page 40
//     WPFP = PAGE_41       Write Protect Program Flash Page 41
//     WPFP = PAGE_42       Write Protect Program Flash Page 42
//     WPFP = PAGE_43       Write Protect Program Flash Page 43
//     WPFP = PAGE_44       Write Protect Program Flash Page 44
//     WPFP = PAGE_45       Write Protect Program Flash Page 45
//     WPFP = PAGE_46       Write Protect Program Flash Page 46
//     WPFP = PAGE_47       Write Protect Program Flash Page 47
//     WPFP = PAGE_48       Write Protect Program Flash Page 48
//     WPFP = PAGE_49       Write Protect Program Flash Page 49
//     WPFP = PAGE_50       Write Protect Program Flash Page 50
//     WPFP = PAGE_51       Write Protect Program Flash Page 51
//     WPFP = PAGE_52       Write Protect Program Flash Page 52
//     WPFP = PAGE_53       Write Protect Program Flash Page 53
//     WPFP = PAGE_54       Write Protect Program Flash Page 54
//     WPFP = PAGE_55       Write Protect Program Flash Page 55
//     WPFP = PAGE_56       Write Protect Program Flash Page 56
//     WPFP = PAGE_57       Write Protect Program Flash Page 57
//     WPFP = PAGE_58       Write Protect Program Flash Page 58
//     WPFP = PAGE_59       Write Protect Program Flash Page 59
//     WPFP = PAGE_60       Write Protect Program Flash Page 60
//     WPFP = PAGE_61       Write Protect Program Flash Page 61
//     WPFP = PAGE_62       Write Protect Program Flash Page 62
//     WPFP = PAGE_63       Write Protect Program Flash Page 63
//     WPFP = PAGE_64       Write Protect Program Flash Page 64
//     WPFP = PAGE_65       Write Protect Program Flash Page 65
//     WPFP = PAGE_66       Write Protect Program Flash Page 66
//     WPFP = PAGE_67       Write Protect Program Flash Page 67
//     WPFP = PAGE_68       Write Protect Program Flash Page 68
//     WPFP = PAGE_69       Write Protect Program Flash Page 69
//     WPFP = PAGE_70       Write Protect Program Flash Page 70
//     WPFP = PAGE_71       Write Protect Program Flash Page 71
//     WPFP = PAGE_72       Write Protect Program Flash Page 72
//     WPFP = PAGE_73       Write Protect Program Flash Page 73
//     WPFP = PAGE_74       Write Protect Program Flash Page 74
//     WPFP = PAGE_75       Write Protect Program Flash Page 75
//     WPFP = PAGE_76       Write Protect Program Flash Page 76
//     WPFP = PAGE_77       Write Protect Program Flash Page 77
//     WPFP = PAGE_78       Write Protect Program Flash Page 78
//     WPFP = PAGE_79       Write Protect Program Flash Page 79
//     WPFP = PAGE_80       Write Protect Program Flash Page 80
//     WPFP = PAGE_81       Write Protect Program Flash Page 81
//     WPFP = PAGE_82       Write Protect Program Flash Page 82
//     WPFP = PAGE_83       Write Protect Program Flash Page 83
//     WPFP = PAGE_84       Write Protect Program Flash Page 84
//     WPFP = PAGE_85       Write Protect Program Flash Page 85
//     WPFP = PAGE_86       Write Protect Program Flash Page 86
//     WPFP = PAGE_87       Write Protect Program Flash Page 87
//     WPFP = PAGE_88       Write Protect Program Flash Page 88
//     WPFP = PAGE_89       Write Protect Program Flash Page 89
//     WPFP = PAGE_90       Write Protect Program Flash Page 90
//     WPFP = PAGE_91       Write Protect Program Flash Page 91
//     WPFP = PAGE_92       Write Protect Program Flash Page 92
//     WPFP = PAGE_93       Write Protect Program Flash Page 93
//     WPFP = PAGE_94       Write Protect Program Flash Page 94
//     WPFP = PAGE_95       Write Protect Program Flash Page 95
//     WPFP = PAGE_96       Write Protect Program Flash Page 96
//     WPFP = PAGE_97       Write Protect Program Flash Page 97
//     WPFP = PAGE_98       Write Protect Program Flash Page 98
//     WPFP = PAGE_99       Write Protect Program Flash Page 99
//     WPFP = PAGE_100      Write Protect Program Flash Page 100
//     WPFP = PAGE_101      Write Protect Program Flash Page 101
//     WPFP = PAGE_102      Write Protect Program Flash Page 102
//     WPFP = PAGE_103      Write Protect Program Flash Page 103
//     WPFP = PAGE_104      Write Protect Program Flash Page 104
//     WPFP = PAGE_105      Write Protect Program Flash Page 105
//     WPFP = PAGE_106      Write Protect Program Flash Page 106
//     WPFP = PAGE_107      Write Protect Program Flash Page 107
//     WPFP = PAGE_108      Write Protect Program Flash Page 108
//     WPFP = PAGE_109      Write Protect Program Flash Page 109
//     WPFP = PAGE_110      Write Protect Program Flash Page 110
//     WPFP = PAGE_111      Write Protect Program Flash Page 111
//     WPFP = PAGE_112      Write Protect Program Flash Page 112
//     WPFP = PAGE_113      Write Protect Program Flash Page 113
//     WPFP = PAGE_114      Write Protect Program Flash Page 114
//     WPFP = PAGE_115      Write Protect Program Flash Page 115
//     WPFP = PAGE_116      Write Protect Program Flash Page 116
//     WPFP = PAGE_117      Write Protect Program Flash Page 117
//     WPFP = PAGE_118      Write Protect Program Flash Page 118
//     WPFP = PAGE_119      Write Protect Program Flash Page 119
//     WPFP = PAGE_120      Write Protect Program Flash Page 120
//     WPFP = PAGE_121      Write Protect Program Flash Page 121
//     WPFP = PAGE_122      Write Protect Program Flash Page 122
//     WPFP = PAGE_123      Write Protect Program Flash Page 123
//     WPFP = PAGE_124      Write Protect Program Flash Page 124
//     WPFP = PAGE_125      Write Protect Program Flash Page 125
//     WPFP = PAGE_126      Write Protect Program Flash Page 126
//     WPFP = PAGE_127      Write Protect Program Flash Page 127
#pragma config WPFP = PAGE_0

//
//   Write/Erase Protect Configuration Region :
//     WPCFG = ON           Configuration Words page erase/write-protected
//     WPCFG = OFF          Configuration Words page not erase/write-protected
#pragma config WPCFG = OFF

//
//   Write Protect Disable bit:
//     WPDIS = ON           WPFP[5:0], WPEND, and WPCFG bits enabled
//     WPDIS = OFF          WPFP[6:0], WPEND, and WPCFG bits ignored
#pragma config WPDIS = OFF

//
//   Write/Erase Protect Region Select bit (valid when WPDIS = 0):
//     WPEND = PAGE_0       Page 0 to WPFP<6:0> erase/write-protected
//     WPEND = PAGE_WPFP    Pages WPFP<6:0> to (Configuration Words page) write/erase protected
#pragma config WPEND = PAGE_0

//
//   Low Speed USB mode with 48 MHz system clock bit:
//     LS48MHZ = SYS24X4    System clock at 24 MHz USB CLKEN divide-by is set to 4
//     LS48MHZ = SYS48X8    System clock at 48 MHz USB CLKEN divide-by is set to 8
#pragma config LS48MHZ = SYS24X4

//
