
#include <usart.h>
#include "inttypes.h"

const uint8_t SOH = 1;
const uint8_t STX = 2;
const uint8_t EOT = 4;
const uint8_t ACK = 6;
const uint8_t NAK = 21;

uint8_t block_num;
uint8_t crc_low;
uint8_t crc_high;
#ifdef DBG_YM
uint8_t wrong_char_count;
uint8_t ack_count;
uint8_t ack_char[128];
uint8_t ack_wanted[128];
#endif

void UpdateCRC(uint8_t x)
{
	x ^= crc_high;
	crc_high = crc_low;
	crc_low = 0;
	if(x & 0x01) { crc_high ^= 0x10; crc_low ^= 0x21; }
	if(x & 0x02) { crc_high ^= 0x20; crc_low ^= 0x42; }
	if(x & 0x04) { crc_high ^= 0x40; crc_low ^= 0x84; }
	if(x & 0x08) { crc_high ^= 0x81; crc_low ^= 0x08; }
	if(x & 0x10) { crc_high ^= 0x12; crc_low ^= 0x31; }
	if(x & 0x20) { crc_high ^= 0x24; crc_low ^= 0x62; }
	if(x & 0x40) { crc_high ^= 0x48; crc_low ^= 0xC4; }
	if(x & 0x80) { crc_high ^= 0x91; crc_low ^= 0x88; }
}

void GetSerialChar(uint8_t x)
{
	uint8_t a;

	while(!DataRdy1USART());
	a = Read1USART();
#ifdef DBG_YM
	if(a != x) ++wrong_char_count;
	ack_wanted[ack_count] = x;
	ack_char[ack_count++] = a;
#endif
}

void SendBlock(const uint8_t rom far *d)
{
	uint8_t n, b;
	while(Busy1USART()); Write1USART(SOH);
	while(Busy1USART()); Write1USART(block_num);
	while(Busy1USART()); Write1USART(block_num ^ 0xFF);
	crc_high = crc_low = 0;
	n = 128;
	do {
		b = *d++;
		while(Busy1USART()); Write1USART(b);
		UpdateCRC(b);
	} while(--n);
	while(Busy1USART()); Write1USART(crc_high);
	while(Busy1USART()); Write1USART(crc_low);
	++block_num;
	GetSerialChar(ACK);
}

void BeginYModem(void)
{
	block_num = 0;
#ifdef DBG_YM
	ack_count = 0;
	wrong_char_count = 0;
#endif
  
	SendBlock((const rom uint8_t far *)"datalog.bin\000103424\032\032\032\032");
	GetSerialChar('C');
}

void EndYModem(void)
{
	uint8_t n;

	//while(Busy1USART()); Write1USART(EOT);
	//GetSerialChar(NAK);

	while(Busy1USART()); Write1USART(EOT);
	GetSerialChar(ACK);

	GetSerialChar('C');

	while(Busy1USART()); Write1USART(SOH);
	while(Busy1USART()); Write1USART(0x00);
	while(Busy1USART()); Write1USART(0xFF);
	n = 128 + 2;
	do {
		while(Busy1USART()); Write1USART(0);
	} while(--n);

#ifdef DBG_YM
	Serial.println(wrong_char_count, DEC);
	for(uint8_t n = 0; n < ack_count; ++n) {
		Serial.print(ack_char[n], DEC);
		Serial.print(" ");
		Serial.println(ack_wanted[n], DEC);
	}
#endif
}
