
;
;    IR to Audio Firmware
;
;    Copyright (C) 2007 Kevin Timmerman
;    irwidget [@t] compendiumarcana [d0t] com
;    http://www.compendiumarcana.com/irwidget
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License along
;    with this program; if not, write to the Free Software Foundation, Inc.,
;    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
;
;
;


#ifdef __12F629
	include <P12F629.INC>
	#define	CORE14
	#define FIRSTREG 0x20
	#define PGMSIZE 1024
#endif
#ifdef __12F675
	include <P12F675.INC>
	#define	CORE14
	#define FIRSTREG 0x20
	#define PGMSIZE 1024
#endif

													; Configuration bits
	__config _CPD_OFF & _CP_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT

	errorlevel -220									; Stupid MPLAB complains about IDLOCS
	org		0x2000									; IDLOCS
	dw		'I','R','A','0'							; IR2Audio Rev 0
	errorlevel +220


BANK1		equ 0x80								; Reduce assembler whining

	radix dec										; Default radix of decimal


													; --- I/O
													; 8 Ground
bLeft1			equ	0								; 7 Left 1
bLeft2			equ	1								; 6 Left 2
bStatusLED		equ	2								; 5 Status LED
bIRLED			equ	3								; 4 IR LED (used as IR detector)
bRight2			equ	4								; 3 Right 2
bRight1			equ	5								; 2 Right 1
													; 1 Power
													;
													;
													;
	org		0x0000									; - Start of program memory

													; - Initiailize peripherals
													;
	movlw	(1<<CM0) | (1<<CM1) | (1<<CM2)			; Disable comparator
	movwf	CMCON									;
													;
	call	PGMSIZE-1								; Get OSCCAL
													;
	bsf		STATUS,RP0								; Bank 1
													;
	movwf	OSCCAL ^ BANK1							; Setup OSCCAL
													;
#ifdef ANSEL										;
	movlw	(1<<ADCS0) | (1<<ADCS2)					; Disable ADC, make all pins digital I/O
	movwf	ANSEL ^ BANK1							;
#endif												;
													;
	movlw	(1<<bIRLED)								; Setup TRIS
	movwf	TRISIO ^ BANK1							;
													;
	bcf		STATUS,RP0								; Bank 0
													;
													;
loop												;
	movlw	(1<<bRight1)|(1<<bLeft1)|(1<<bStatusLED); Neutral output, Status LED off
	movwf	GPIO									;
													;
	btfsc	GPIO,bIRLED								; Wait for IR on
	goto	$-1										;
													;
	movlw	(1<<bLeft1)|(1<<bLeft2)					; Left High, Right Low output, Status LED on
	movwf	GPIO									;
													;
	btfss	GPIO,bIRLED								; Wait for IR off
	goto	$-1										;
													;
	movlw	(1<<bRight1)|(1<<bLeft1)|(1<<bStatusLED); Neutral output, Status LED off
	movwf	GPIO									;
													;
	btfsc	GPIO,bIRLED								; Wait for IR on
	goto	$-1										;
													;
	movlw	(1<<bRight1)|(1<<bRight2)				; Left Low, Right High output, Status LED on
	movwf	GPIO									;
													;
	btfss	GPIO,bIRLED								; Wait for IR off
	goto	$-1										;
													;
	goto	loop									;
													;
													;
	end												;
													;
