
; MiniPOV3 serial tx test
;
; Copyright (C) 2008 Kevin Timmerman
;
; irwidget [@t] compendiumarcana [d0t] com
; http://www.compendiumarcana.com/irwidget
;
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http://www.gnu.org/licenses/>.




	; DE9			tiny2323
	;-------------------------
	; 1 CD		<-
	; 2 RxD		<-	3  D1 TxD
	; 3 TxD		->	17 B5 DI
	; 4	DTR		->	19 B7 CLK
	; 5 Gnd		--	10    Gnd
	; 6 DSR		<-
	; 7	RTS		->	1  A2 Reset
	; 8	CTS		<-	18 B6 DO
	; 9 RI		<-
	;
	;

	;.DEVICE	ATtiny2313							; This is in the include file
													;
	.INCLUDE	"tn2313def.inc"						; Register/Bit Definitions for the ATtiny2313
													;
													;
													; - Register usage
	.DEF	temp        = r16						;
	.DEF	temp2       = r17						;
	.DEF	delay_cnt   = r18						;
	.DEF	tx_data     = r19						;
	.DEF	bit_count   = r20						;
													;
													; - I/O Port usage
													;
	.EQU	tx_port         = PORTD					; Serial data to host
	.EQU	tx_bit          = 1						;
	.EQU	mode1_port      = PINB					; Mode select
	.EQU	mode1_bit       = 7						;
	.EQU	mode2_port      = PINB					;
	.EQU	mode2_bit       = 5						;
													;
													;
													; - Interrupt Vectors
													;
	rjmp	init									;  1 0000 Reset
	rjmp	bad_int									;  2 0001 INT0
	rjmp	bad_int									;  3 0002 INT1
	rjmp	bad_int									;  4 0003 T1 Capture
	rjmp	bad_int									;  5 0004 T1 Compare A
	rjmp	bad_int									;  6 0005 T1 Overflow
	rjmp	bad_int									;  7 0006 T0 Overflow
	rjmp	bad_int									;  8 0007 UART Rx
	rjmp	bad_int									;  9 0008 UART Tx Empty
	rjmp	bad_int									; 10 0009 UART Tx Complete
	rjmp	bad_int									; 11 000A Analog Comparator
	rjmp	bad_int									; 12 000B Pin Change
	rjmp	bad_int									; 13 000C T1 Compare B
	rjmp	bad_int									; 14 000D T0 Compare A
	rjmp	bad_int									; 15 000E T0 Compare B
	rjmp	bad_int									; 16 000F USI Start
	rjmp	bad_int									; 17 0010 USI Overflow
	rjmp	bad_int									; 18 0011 EEPROM
	rjmp	bad_int									; 19 0012 Watchdog
													;
bad_int:											; Unused interrupts
	rjmp	PC										;
													;
													;
init:												; --- Initialize
	ldi		temp,0b01011111							; Mode selects are inputs, all other outputs (LEDs)
	out		DDRB,temp								;
	ldi		temp,0b00000000							; Turn off all LEDs
	out		PORTB,temp								;
													;
	ldi		temp,0b00000010							; Tx data is output
	out		DDRD,temp								;
	ldi		temp,0b00000000							;
	out		PORTD,temp								;
													;
	ldi		temp,0xDF								; Set stack pointer to top of RAM
	out		SPL,temp								;



serial_tx_test:
	ldi		temp,'0'
next_char:
	mov		tx_data,temp
	rcall	tx_115
	ldi		temp2,255
char_delay:
	ldi		delay_cnt,255
	rcall	delay
	dec		temp2
	brne	char_delay
	inc		temp
	cpi		temp,'z'+1
	brne	next_char
	ldi		tx_data,13
	rcall	tx_115
	ldi		tx_data,10
	rcall	tx_115
	rjmp	serial_tx_test


													;
													; --- 115,200,8,N,1 async serial transmit
tx_115:												;
	sbi		tx_port,tx_bit							; Start bit
	ldi		bit_count,10							; 10 bits to send (start, 8 data, stop)
	ldi		delay_cnt,46							; Wait for bit duration
	rcall	delay									;
tx_loop:											; - Do a bit
	sec												; Shift in stop bit
	ror		tx_data									; Shift out next bit
	brcs	tx_one									; One...
	nop												; Zero
	sbi		tx_port,tx_bit							; Signal zero bit (data is inverted!)
	rjmp	tx_next									;
tx_one:												;
	cbi		tx_port,tx_bit							; Signal one bit (data is inverted!)
	rjmp	tx_next									;
tx_next:											;
	ldi		delay_cnt,40							; Wait for bit duration
	sbrc	bit_count,0								; Keep timing perfect (69.444 instruction cycles per bit)
	ldi		delay_cnt,41							;  (alternate between 69 and 70 cycles)
	rcall	delay									;
	dec		bit_count								; Decrement bit count
	brne	tx_loop									; Next bit...
	ret												; Return
													;
													;
													; --- Delay with one instruction cycle granularity
delay:												;
	sbrc	delay_cnt,0								; Test bit 0
	rjmp	PC+1									; + 1 cycle if bit 0 is set
	sbrs	delay_cnt,1								; Test bit 1
	rjmp	PC+3									;
	rjmp	PC+1									; + 2 cycles if bit 1 is set
	nop												;
	cbr		delay_cnt,3								; Mask off bits 0 and 1, test for zero
delayl4:											;
	breq	delayex									; Exit if delay count is zero
	subi	delay_cnt,4								; Decrement delay count by 4 every 4 instruction cycles
	rjmp	delayl4									;
delayex:											;
	ret												; Return
													;
													;
