;
;    Kill A Watt serial interface
;
;    Copyright (C) 2010 Kevin Timmerman
;    kaw [@t] compendiumarcana [d0t] com
;    http://www.compendiumarcana.com/kaw
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
; - Kill A Watt
; 0.0021 * 100K / 2.55K = 82.353 mV per Amp
; 1M / 1K = 10 mV per Volt
;
; - PIC
; 5.00 / 1024 = 4.883 mV per ADC step
; 488.3 mV per ADC step
; 59.3 mA per ADC step
;
; - X-Bee
; 3.3 * (14.7K / 10K) / 1024 = 4.737 mV per ADC step
; 473.7 mV per ADC step
; 57.5 mA per ADC step
;




#include <p12F615.inc>								; Header for PIC12F615
													;
													; Config word
	__config _BOR_ON & _IOSCFS_8MHZ & _CP_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_ON & _INTOSCIO
													;
	radix dec										; Default to decimal
													;
	errorlevel -302									; Don't complain about bank
													;
	cblock 0x40										; Register allocation
	adc_samples	: 3 * 18							;
	sample_count									;
	flags											;
	temp1											;
	checksum										;
	tx_data											;
	bit_count										;
	bit_dur											;
	endc											;
													;
													;
	org			0									; Reset vector
	call		Init								;
	goto		Start								;
													;
	org			4									; ISR
	goto		$									;
													;
Start												;
	call		GetSamples							; - Get ADC samples
													;
	call		SendResults							; - Send to host
													;
	movlw		250									; - Wait 500 ms
	call		Delay_ms							;
	movlw		250									;
	call		Delay_ms							;
													;
	goto		Start								; - Repeat forever
													;
													;
GetSamples											;
	clrwdt											; Clear watchdog
	movlw		18									; Setup sample count
	movwf		sample_count						;
	movlw		adc_samples							; Setup buffer pointer
	movwf		FSR									;
													;
sample_loop											;
	call		WaitForSampleTime					; Wait for sample time
	movlw		(1 << ADFM) | (1 << ADON)			; Select AN0 (Voltage)
	movwf		ADCON0								;
	goto		$+1									; Allow ADC input to settle
	goto		$+1									;
	goto		$+1									;
	goto		$+1									;
	goto		$+1									;
	bsf			ADCON0, GO							; Begin ADC converstion
	btfsc		ADCON0, NOT_DONE					; Wait for conversion to complete
	goto		$-1									;
	movlw		(1 << ADFM) | (1 << CHS0) | (1 << ADON) ; Select AN1 (Amperage)
	movwf		ADCON0								;
	bsf			STATUS, RP0							; Get LSB of ADC
	movf		ADRESL, W							;
	bcf			STATUS, RP0							;
	movwf		INDF								; Save in buffer
	incf		FSR, F								; Inc buffer pointer
	swapf		ADRESH, W							; Get MSB of ADC, put in upper nibble
	andlw		0x30								; Mask off unused bits and lower nibble
	movwf		INDF								; Save in buffer - don't increment buffer pointer
	goto		$+1									; Wait for ADC input to settle
	bsf			ADCON0, GO							; Begin ADC converstion
	btfsc		ADCON0, NOT_DONE					; Wait for conversion to complete
	goto		$-1									;
	movf		ADRESH, W							; Get MSB of ADC
	andlw		0x03								; Mask off unused bits
	iorwf		INDF, F								; OR with MSB of previous sample
	incf		FSR, F								; Increment buffer pointer
	bsf			STATUS, RP0							; Get LSB of ADC
	movf		ADRESL, W							;
	bcf			STATUS, RP0							;
	movwf		INDF								; Save in buffer
	incf		FSR, F								; Increment buffer pointer
	movlw		(1 << ADFM) | (1 << CHS2) | (1 << ADON) ; Select VCRef
	movwf		ADCON0								;
													;
	decfsz		sample_count, F						; Decrement sample count
	goto		sample_loop							; If not zero, get next sample...
	return											; Return
													;
SendResults											;
	movlw		0x7E								; Start of packet
	call		txzc								;
	movlw		0									; Length MSB
	call		txzc								;
	movlw		8 + (4 * 18)						; Length LSB
	call		txzc								;
	clrf		checksum							; Clear checksum
	movlw		0x83								; 16 bit ADC data
	call		txzc								;
	movlw		0									; Source address MSB
	call		txzc								;
	movlw		0									; Source address LSB
	call		txzc								;
	movlw		0x22								; RSSI value
	call		txzc								;
	movlw		0x00								; Option
	call		txzc								;
	movlw		18									; Sample count
	call		txzc								;
													; Channel indicator MSB  -- A5 A4 A3  A2 A1 A0 D8
	movlw		0x22								; 0x22 = A4 and A0        0  0  1  0   0  0  1  0
	call		txzc								;
													; Channel indicator LSB  D7 D6 D5 D4  D3 D2 D1 D0
	movlw		0x00								; 0x00 = None
	call		txzc								;
													; - ADC samples
	movlw		18									; Setup sample count
	movwf		sample_count						;
	movlw		adc_samples							; Setup sample buffer pointer
	movwf		FSR									;
tx_adc_samples										;
	movf		INDF, W								; Get LSB of voltage sample
	movwf		temp1								; Save it
	incf		FSR, F								; Increment buffer pointer
	swapf		INDF, W								; Get MSB of voltage sample
	andlw		0x03								; Mask off MSB of current sample
	call		txzc								; Send MSB of voltage
	movf		temp1, W							; Get LSB of voltage
	call		txzc								; Send LSB of voltage
	movf		INDF, W								; Get MSB of current sample
	andlw		0x03								; Mask off MSB of voltage sample
	call		txzc								; Send MSB of current
	incf		FSR, F								; Incrment buffer pointer
	movf		INDF, W								; Get LSB of current sample
	call		txzc								; Send LSB of current
	incf		FSR, F								; Increment buffer pointer
	decfsz		sample_count, F						; Decrement sample count
	goto		tx_adc_samples						; If not zero, send next sample...
													;
	movf		checksum, W							; Checksum
	goto		txzc								; Send and return to caller
													;
													;
txzc												; --- Transmit char at zero crossing
	movwf		tx_data								; Save char to tx
#if 1												;
	movlw		(1 << ADFM) | (1 << ADON)			; Select AN0 (Voltage)
	movwf		ADCON0								;
	goto		$+1									; Allow ADC input to settle
	goto		$+1									;
	goto		$+1									;
	goto		$+1									;
	goto		$+1									;
waitzcl												; - Wait for low half of AC cycle
	clrwdt											;
	bsf			ADCON0, GO							; Begin ADC converstion
	btfsc		ADCON0, NOT_DONE					; Wait for conversion to complete
	goto		$-1									;
	btfsc		ADRESH, 1							; Loop until ADC < 512
	goto		waitzcl								;
waitzch												; - Wait for zero cross
	clrwdt											;
	bsf			ADCON0, GO							; Begin ADC converstion
	btfsc		ADCON0, NOT_DONE					; Wait for conversion to complete
	goto		$-1									;
	btfss		ADRESH, 1							; Loop until ADC >= 512
	goto		waitzch								;
													;
	movlw		(1 << ADFM) | (1 << CHS2) | (1 << ADON) ; Select VCRef
	movwf		ADCON0								;
#else												; - For debug (no AC present)
	movlw		16									;
	call		Delay_ms							;
#endif												;
	movf		tx_data, W							; Restore tx char
													;
ser_tx												; --- Send char to host
	addwf		checksum, F							; Update checksum
	movwf		tx_data								; Save data to send
	movlw		1 + 8 + 1 + 1						; Start + 8 data + Stop + Char spacing
	movwf		bit_count							; Setup bit count
	goto		tx0									; Send start bit...
tx_bit												; - Send a bit
	bsf			STATUS, C							; Shift in stop bit
	rrf			tx_data, F							; Get at bit of data
	btfsc		STATUS, C							; Test it
	goto		tx1									; Send one...
	nop												; Send zero...
tx0													;
	bsf			GPIO, 5								; - One bit
	goto		bit_dly								;
tx1													; - Zero bit
	bcf			GPIO, 5								;
	goto		bit_dly								;
bit_dly												; - Bit delay with 1 instruction cycle granularity
	btfsc		bit_dur, 0							; Add one instruction cycle for bit 0
	goto		$+1									;
	btfsc		bit_dur, 1							; Add two instruction cycles for bit 1
	goto		$+1									;
	btfsc		bit_dur, 1							;
	goto		$+1									;
	movf		bit_dur, W							; Add four instruction cycles for remainder
	addlw		256 - 4								; Subtract 4 from bit duration until underflow
	btfsc		STATUS, C							; Underflow?
	goto		$-2									; No, loop...
													;
	decfsz		bit_count, F						; Decrement bit count
	goto		tx_bit								; Next bit...
													;
	return											; Return
													;
													;
WaitForSampleTime									; --- Wait for sample timer tick
	bcf			PIR1, TMR2IF						;
	btfss		PIR1, TMR2IF						;
	goto		$-1									;
	return											;
													;
													;
Delay_ms											; --- Delay 1 to 256 milliseconds
													; Use a value of 0 for 256 ms delay
	movwf		bit_count							; Save delay duration
	movlw		257 - 250							; 250 * 4 us = 1 ms
	goto		dmsl + 1							; Compensate for loop and call/return overhead
dmsi												; - Outer loop - N ms
	goto		$+1									;
	goto		$+1									; Keep timing precise
	nop												; Compensate for loop overhead
	movlw		257 - 250							; 250 * 4 us = 1 ms
dmsl												; - Inner loop - 4 us - 8 instructions at 8 MHz
	nop												; 1
	goto		$+1									; 2 3
	clrwdt											; 4
	addlw		1									; 5
	btfss		STATUS, C							; 6
	goto		dmsl								; 7 8
	decfsz		bit_count, F						; Decrement outer loop count
	goto		dmsi								; Loop if not zero...
	return											; Return
													;
													;
Init												; - Setup I/O
	bsf			STATUS, RP0							;
													;
	movlw		(1 << 1) | (1 << 0)					; Make GP0 and GP1 inputs, all others output
	movwf		TRISIO								;
													; *GPPU = 0 - WPU enabled
													; INTEDG = 0
													; T0CS = 1 - Internal clock source
													; T0SE = 1 - Inc on falling edge
													; PSA = 1 - Assign prescaller to WDT
													; PSx - WDT prescaler = 2 (4:1), 72 mS
	movlw		(1<<T0CS) | (1<<T0SE) | (1<<PSA) | (1<<PS1)
	movwf		OPTION_REG							; Set options
													;
	movlw		(1 << ADCS2) | (1 << ADCS0) | (1 << AN1) | (1 << AN0)
	movwf		ANSEL								; Set conversion time to 2 us, enable AN0 and AN1
													;
													; 60 Hz * 18 = 1080 Hz = 926 us
													; 926 us / 8 us = 115.75
	;movlw		116 - 1								; 116 * 8 = 928 us
													; 928 * 18 * 60 = 1,002,240 = 2.24 ms drift per second
													;
													; 60 Hz * 17 = 1020 Hz = 980 us
													; 980 us / 8 us = 122.4
	movlw		123 - 1								; 123 * 8 = 984
													; 984 * 17 * 60 = 1,003,680 = 3.68 ms drift per second
	movwf		PR2									;
													;
	bcf			STATUS, RP0							;
													;
	movlw		(1 << TMR2ON) | (1 << T2CKPS1)		; Timer 2 on, prescale = 16, postscale = 1
	movwf		T2CON								; 8 MHz / 4 / 16 = 125 KHz = 8 us
													;
	clrf		TMR2								;
													;
	movlw		(1 << CMVREN) | (1 << VRR) | 11		; Setup CVRef to 2.3 V
	movwf		VRCON								;
													;
													;  8 MHz / 4 = 2 MIPS
	movlw		208 - 21							;  2M / 208 = 9,615
	movwf		bit_dur								;
													;
	return											;
													;
	end												;



#if 0
	movlw		'T'
	call		ser_tx
	movlw		'e'
	call		ser_tx
	movlw		's'
	call		ser_tx
	movlw		't'
	call		ser_tx
	movlw		13
	call		ser_tx
	movlw		10
	call		ser_tx
#endif

#if 0
tl
	clrwdt
	movf		temp1, W
	call		txzc
	incf		temp1, F
	goto		tl
#endif
